--use CLEAN_Address
use JuryMaster
-----------------------------------------------------------
-- Set Parameters
-----------------------------------------------------------
Declare @SettingsGroupName nvarchar(50)
Set @SettingsGroupName = ''

exec [RTISRV64\SQL2014EXPRESS].CLEAN_Address..Set_Setting @SettingsGroupName,'VerboseSuggestList','1'


-----------------------------------------------------------
-- Declare test variables
-----------------------------------------------------------
Declare
@Group nvarchar(50),
@Address_Name nvarchar(300), /* IN/OUT - Full Name - will be parsed if specified */
@Company nvarchar(256),  /* IN/OUT */
@Attention nvarchar(256), /* IN/OUT */
@Address nvarchar(256) ,  /* IN/OUT - House float and Street Address */
@Suite nvarchar(256) ,  /* IN/OUT - Suite / Apartment float */
@Private_Mailbox nvarchar(100) ,  /* Private Mail Box Facility */
-- Generic Address Lines 1-8
@Address_Line_1 nvarchar(256) ,  /* IN/OUT */
@Address_Line_2 nvarchar(256) ,  /* IN/OUT */
@Address_Line_3 nvarchar(256) ,  /* IN/OUT */
@Address_Line_4 nvarchar(256) ,  /* IN/OUT */
@Address_Line_5 nvarchar(256) ,
@Address_Line_6 nvarchar(256) ,
@Address_Line_7 nvarchar(256) ,
@Address_Line_8 nvarchar(256) ,
-- Common Address Components
@City nvarchar(100) ,  /* IN/OUT */
@City_Abbreviation nvarchar(100) ,
@ST nvarchar(100) ,  /* IN/OUT */
@Postal_Code nvarchar(50) ,   /* IN/OUT */
@Postal_Code_Extended nvarchar(50) ,   /* IN/OUT - ie ZIP+4 */
@Last_Line nvarchar(256) ,  /* Last Address Line: City@ State Zip-Plus4 (US Only) , */
@Country_Code nvarchar(30) ,   /* IN/OUT */
@Country_Name nvarchar(100) ,  /* IN/OUT */
@Urbanization nvarchar(256) ,  /* IN/OUT - Puerto Rico Addresses Only */
@Province nvarchar(100) ,  /* IN/OUT - International Addresses */
@Carrier_Route nvarchar(20) ,
@Delivery_Point_Check_Digit nvarchar(10) ,
@Delivery_Point nvarchar(2) ,
@Check_Digit nvarchar(1) ,
-- Parsed Street Components - Output only - not to be used as input
@Parsed_Address_Range nvarchar(60) ,
@Parsed_Address_float nvarchar(60) ,
@Parsed_Pre_Direction nvarchar(40) ,
@Parsed_Street_Name nvarchar(100) ,
@Parsed_Street_Suffix nvarchar(40) ,
@Parsed_Post_Direction nvarchar(40) ,
@Parsed_Unit_Type  nvarchar(40) ,
@Parsed_Unit_float  nvarchar(40) ,
@Parsed_Private_Mailbox_Type  nvarchar(40) ,  /* Private Mail Box Type (ie PMB) , */
@Parsed_Private_Mailbox_float nvarchar(40) ,  /* Private Mail Box float (ie 124B) , */
-- Suggestion List - returns list of possible matches when an address is not verified
-- - The returned list is separated by ";" (semi-colon) ,@ and can easily be replaced with a CR chr(10) , or <BR>
-- - pass fn_error_suggest_count > 0 in the Verify or Verify_Generic procedure to activate this feature
-- - If fb_verbose_suggest_list is passed in as TRUE@ the results will contain street name detail for each line@
--   instead of an abbreviated results list where the street name does not repeat for multiple records
--   - The verbose option also puts a ":" (colon) , delimiter between each field for a suggestion
@Suggestion_List nvarchar(4000) ,
-- Enhancement Address Fields
@County_Code nvarchar(20) ,
@County_Name nvarchar(100) ,
@Timezone_Code nvarchar(5) ,
@Timezone_String nvarchar(100) ,
@Error_Code nvarchar(20) ,    /* Primary field to check for an address error (View: CLN_ADDRESS_ERRORS_V) , */
@Error_String nvarchar(4000) ,
@Status_Code nvarchar(20) ,    /* Address Status code (View: CLN_ADDRESS_STATUS_V) , */
@DPV_Status nvarchar(20) ,    /* Delivery Point Validation Status - AA BB RR are verified successfully */
@DPV_Error_Code nvarchar(20) ,    /* Decode of DPV_Status and Error_Code to return prominant error code */
@RBDI_Code nvarchar(20) ,    /* (R) ,esidential / (B) ,usiness Delivery Indicator (R/B) , - EXTRA DATA OPTION */
@CMRA nvarchar(1) ,     /* Commercial Mail Receiving Agency (Y/N) , */
@Address_Type_Code nvarchar(20) ,
@Address_Type_String nvarchar(100) ,
@MSA nvarchar(20) ,
@PMSA nvarchar(20) ,
@Congressional_District nvarchar(20) ,
@LACS_Code nvarchar(20) ,    /* L = Address has undergone a conversion */
@Automation_Code nvarchar(20) ,    /* Y = Carrier Route sortation rates apply for this Postal Code */
@Facility_Code nvarchar(20) ,
@Zip_Type_Code nvarchar(20) ,    /* NULL = Standard; P = PO Box Only Postal Code; U = Unique for Organization (ie IRS) ,; M = Military */
-- GeoCoder Fields
@Latitude float(24),
@Longitude float(24),
@Census_Tract nvarchar(10) ,
@Census_Block nvarchar(10) ,
-- Name Parse Fields
@FirstName nvarchar(100) ,   /* IN/OUT */
@Middle_Name nvarchar(100) ,   /* IN/OUT */
@LastName nvarchar(100) ,   /* IN/OUT */
@Name_Prefix nvarchar(50) ,   /* IN/OUT */
@Name_Suffix nvarchar(50) ,   /* IN/OUT */
@Standardized_First_Name nvarchar(100) ,
@Gender nvarchar(50) ,    /* M = Male; F = Female; N = Neutral; U = Unknown */
@First_Name_2 nvarchar(100) ,
@Middle_Name_2 nvarchar(100) ,
@Last_Name_2 nvarchar(100) ,
@Name_Prefix_2 nvarchar(50) ,
@Name_Suffix_2 nvarchar(50) ,
@Standardized_First_Name_2 nvarchar(100) ,
@Gender_2 nvarchar(50) ,    /* M = Male; F = Female; N = Neutral; U = Unknown */
@Name_Parse_Status_Code nvarchar(20) ,   /* ' ' = Successful Parse; 'V' = Vulgar world found; 'X' = Unable to Parse */
-- Telephone Check Fields
@Phone_float nvarchar(30) ,   /* IN/OUT */
@Phone_float_Output_Format nvarchar(30) ,   /* Format mask to apply for output - Use # for place holder@ ie (###) ,###-#### */
@New_Phone_float nvarchar(30) ,
@New_Phone_Area_Code nvarchar(15) ,
@Phone_Area_Code nvarchar(15) ,   /* IN/OUT */
@Phone_Prefix nvarchar(15) ,   /* IN/OUT */
@Phone_Suffix nvarchar(15) ,   /* IN/OUT */
@Phone_Extension nvarchar(15) ,
@Phone_Distance float(24),
@Phone_Check_Status_Code nvarchar(20) ,
@Phone_Check_Error_Code nvarchar(20),
@AddressKey nvarchar(100),
@CountyFIPS nvarchar(100),
@CountyName nvarchar(100),
--ref SqlString standardizedFirstNameField, -> Standardized_First_Name (already exists)
@Standardized_Middle_Name nvarchar(100),
@Results nvarchar(4000),
@GenericAddressLineFormat nvarchar(100),
@CBSACode nvarchar(100),
@CBSATitle nvarchar(100),
@CBSALevel nvarchar(100),
@CBSADivisionCode nvarchar(100),
@CBSADivisionTitle nvarchar(100),
@CBSADivisionLevel nvarchar(100)
--
-- Sample customer defined table
--
Declare @ORIG_ID [decimal](8, 0)
Declare @TOWN_CODE [varchar](3)
Declare @LAST_NAME [varchar](25)
Declare @FIRST_NAME [varchar](15)
Declare @MIDDLE_INIT [varchar](1)
Declare @SUFFX [varchar](3)
Declare @DOB [varchar](8)
Declare @SSN [varchar](9)
Declare @STREET1 [varchar](30)
Declare @STREET2 [varchar](30)
Declare @TOWN [varchar](20)
Declare @STATE [varchar](2)
Declare @ZIP1 [varchar](5)
Declare @ZIP2 [varchar](6)
Declare @MVL [varchar](9)
Declare @VOTER_STAT [varchar](1)
Declare @TYPE_CODE [varchar](2)
Declare @TYPE_ORDER [varchar](2)
Declare @EXP_CODE [varchar](3)
Declare @YEAR_NO [decimal](4, 0)

truncate table ADOL_STANDZ

Declare cur cursor 
for select * from ADOL_ORIG

open cur

Fetch next from cur
into @ORIG_ID,@TOWN_CODE,@LAST_NAME,@FIRST_NAME,@MIDDLE_INIT,@SUFFX,@DOB,@SSN,
@STREET1,@STREET2,@TOWN,@STATE,@ZIP1,@ZIP2,@MVL,@VOTER_STAT,@TYPE_CODE,@TYPE_ORDER,@EXP_CODE,@YEAR_NO

while @@FETCH_STATUS = 0
  begin
	-----------------------------------------------------------
	-- set some test data
	-----------------------------------------------------------
	select 
	@Group = '',
	@Address_Name = null, 
	@Company = '',  /* IN/OUT */
	@Attention = '' , /* IN/OUT */
	@Address= ''  ,  /* IN/OUT - House  and Street Address */
	@Suite = ''  ,  /* IN/OUT - Suite / Apartment  */
	@Private_Mailbox  = '',  /* Private Mail Box Facility */
	-- Generic Address Lines 1-8
	@Address_Line_1  = @STREET1 ,  /* IN/OUT */
	@Address_Line_2  = @STREET2 ,  /* IN/OUT */
	@Address_Line_3  = '' ,  /* IN/OUT */
	@Address_Line_4  = '' ,  /* IN/OUT */
	@Address_Line_5  = '' ,
	@Address_Line_6  = '' ,
	@Address_Line_7  = '' ,
	@Address_Line_8  = '' ,
	-- Common Address Components

	@City  = @TOWN,  /* IN/OUT */
	@City_Abbreviation  = '' ,
	@ST  = @STATE ,  /* IN/OUT */
	@Postal_Code   = @ZIP1,   /* IN/OUT */
	@Postal_Code_Extended   = '',   /* IN/OUT - ie ZIP+4 */
	@Last_Line   = '',  /* Last Address Line: City@ State Zip-Plus4 (US Only) , */
	@Country_Code  = '' ,   /* IN/OUT */
	@Country_Name  = '' ,  /* IN/OUT */
	@Urbanization  = '' ,  /* IN/OUT - Puerto Rico Addresses Only */
	@Province  = '' ,  /* IN/OUT - International Addresses */
	@Carrier_Route   = '',
	@Delivery_Point_Check_Digit   = '',
	@Delivery_Point  = '' ,
	@Check_Digit   = '',
	-- Parsed Street Components - Output only - not to be used as input
	@Parsed_Address_Range   = '',
	@Parsed_Address_float = ''  ,
	@Parsed_Pre_Direction = ''  ,
	@Parsed_Street_Name = ''  ,
	@Parsed_Street_Suffix  = '' ,
	@Parsed_Post_Direction = '',
	@Parsed_Unit_Type  = ''  ,
	@Parsed_Unit_float = ''   ,
	@Parsed_Private_Mailbox_Type = ''   ,  /* Private Mail Box Type (ie PMB) , */
	@Parsed_Private_Mailbox_float  = ''  ,  /* Private Mail Box  (ie 124B) , */
	-- Suggestion List - returns list of possible matches when an address is not verified
	-- - The returned list is separated by ";" (semi-colon) ,@ and can easily be replaced with a CR chr(10) , or <BR>
	-- - pass fn_error_suggest_count > 0 in the Verify or Verify_Generic procedure to activate this feature
	-- - If fb_verbose_suggest_list is passed in as TRUE@ the results will contain street name detail for each line@
	--   instead of an abbreviated results list where the street name does not repeat for multiple records
	--   - The verbose option also puts a ":" (colon) , delimiter between each field for a suggestion
	@Suggestion_List  = '',
	-- Enhancement Address Fields
	@County_Code  = '' ,
	@County_Name  = '' ,
	@Timezone_Code  = '' ,
	@Timezone_String   = '',
	@Error_Code   = '',    /* Primary field to check for an address error (View: CLN_ADDRESS_ERRORS_V) , */
	@Error_String  = '',
	@Status_Code  = '' ,    /* Address Status code (View: CLN_ADDRESS_STATUS_V) , */
	@DPV_Status   = '',    /* Delivery Point Validation Status - AA BB RR are verified successfully */
	@DPV_Error_Code  = '' ,    /* Decode of DPV_Status and Error_Code to return prominant error code */
	@RBDI_Code = '',    /* (R) ,esidential / (B) ,usiness Delivery Indicator (R/B) , - EXTRA DATA OPTION */
	@CMRA  = '' ,     /* Commercial Mail Receiving Agency (Y/N) , */
	@Address_Type_Code  = '' ,
	@Address_Type_String   = '',
	@MSA  = '' ,
	@PMSA  = '' ,
	@Congressional_District = ''  ,
	@LACS_Code   = '',    /* L = Address has undergone a conversion */
	@Automation_Code = ''  ,    /* Y = Carrier Route sortation rates apply for this Postal Code */
	@Facility_Code  = '' ,
	@Zip_Type_Code = ''  ,    /* '' = Standard; P = PO Box Only Postal Code; U = Unique for Organization (ie IRS) ,; M = Military */
	-- GeoCoder Fields
	@Latitude  = '',
	@Longitude  = '',
	@Census_Tract  = '' ,
	@Census_Block  = '' ,
	-- Name Parse Fields
	@FirstName  = 'Dave',   /* IN/OUT */
	@Middle_Name = 'Bill'  ,   /* IN/OUT */
	@LastName  = 'Noderer' ,   /* IN/OUT */
	@Name_Prefix  = '' ,   /* IN/OUT */
	@Name_Suffix  = '' ,   /* IN/OUT */
	@Standardized_First_Name  = '' ,
	@Gender = ''  ,    /* M = Male; F = Female; N = Neutral; U = Unknown */
	@First_Name_2 = ''  ,
	@Middle_Name_2  = '' ,
	@Last_Name_2  = '' ,
	@Name_Prefix_2 = ''  ,
	@Name_Suffix_2 = ''  ,
	@Standardized_First_Name_2  = '' ,
	@Gender_2   = '',    /* M = Male; F = Female; N = Neutral; U = Unknown */
	@Name_Parse_Status_Code = ''  ,   /* ' ' = Successful Parse; 'V' = Vulgar world found; 'X' = Unable to Parse */
	-- Telephone Check Fields
	@Phone_float  = ''  ,   /* IN/OUT */
	@Phone_float_Output_Format  = '' ,   /* Format mask to apply for output - Use # for place holder@ ie (###) ,###-#### */
	@New_Phone_float = ''  ,
	@New_Phone_Area_Code  = '' ,
	@Phone_Area_Code = ''  ,   /* IN/OUT */
	@Phone_Prefix  = '' ,   /* IN/OUT */
	@Phone_Suffix  = '' ,   /* IN/OUT */
	@Phone_Extension = ''  ,
	@Phone_Distance = '' ,
	@Phone_Check_Status_Code   = '',
	@Phone_Check_Error_Code  = '',

	@AddressKey = @ORIG_ID,
	@CountyFIPS = '',
	@CountyName = '',
	--ref SqlString standardizedFirstNameField, -> Standardized_First_Name (already exists)
	@Standardized_Middle_Name = '',
	@Results = '',
	@GenericAddressLineFormat = '',
	@CBSACode = '',
	@CBSATitle = '',
	@CBSALevel = '',
	@CBSADivisionCode = '',
	@CBSADivisionTitle  = '',
	@CBSADivisionLevel = ''
	------------------------------------------------------------
	-- Call with test data
	------------------------------------------------------------
	EXEC [RTISRV64\SQL2014EXPRESS].CLEAN_Address..Verify
	--EXEC Verify 
	@Group,@Address_Name output,@Company output,@Attention output,
	@Address output, @Suite output,@Private_Mailbox output,
	@Address_Line_1 output,@Address_Line_2 output,@Address_Line_3 output,@Address_Line_4 output,
	@Address_Line_5 output,@Address_Line_6 output,@Address_Line_7 output,@Address_Line_8 output,
	@City output,@City_Abbreviation output,@ST output,@Postal_Code output,@Postal_Code_Extended output,
	@Last_Line output,@Country_Code output,@Country_Name output,@Urbanization output,@Province output,
	@Carrier_Route output,@Delivery_Point_Check_Digit output,@Delivery_Point output,@Check_Digit output,
	@Parsed_Address_Range output,@Parsed_Address_float output,@Parsed_Pre_Direction output,@Parsed_Street_Name output,@Parsed_Street_Suffix output,@Parsed_Post_Direction output,@Parsed_Unit_Type  output,@Parsed_Unit_float  output,@Parsed_Private_Mailbox_Type output,@Parsed_Private_Mailbox_float output,
	@Suggestion_List output,
	@County_Code output,@County_Name output,
	@Timezone_Code output,@Timezone_String output,
	@Error_Code output,@Error_String output,@Status_Code output,
	@DPV_Status output,@DPV_Error_Code output,
	@RBDI_Code output,@CMRA output, @Address_Type_Code output,@Address_Type_String output,
	@MSA output,@PMSA output,@Congressional_District output,@LACS_Code output,@Automation_Code output,@Facility_Code output,@Zip_Type_Code output,
	@Latitude output,@Longitude output,@Census_Tract output,@Census_Block output,
	@FirstName output,@Middle_Name output,@LastName output,@Name_Prefix output,@Name_Suffix output,@Standardized_First_Name output,@Gender output,
	@First_Name_2 output,@Middle_Name_2 output,@Last_Name_2 output,@Name_Prefix_2 output,@Name_Suffix_2 output,@Standardized_First_Name_2 output,@Gender_2 output,
	@Name_Parse_Status_Code output,@Phone_float output,@Phone_float_Output_Format,
	@New_Phone_float output,@New_Phone_Area_Code output,@Phone_Area_Code output,@Phone_Prefix output,@Phone_Suffix output,@Phone_Extension output,
	@Phone_Distance output,@Phone_Check_Status_Code output,@Phone_Check_Error_Code output,
	@AddressKey output,
	@CountyFIPS output,
	@CountyName output,
	--ref SqlString standardizedFirstNameField, -> Standardized_First_Name (already exists)
	@Standardized_Middle_Name output,
	@Results output,
	@GenericAddressLineFormat output,
	@CBSACode output,
	@CBSATitle output,
	@CBSALevel output,
	@CBSADivisionCode output,
	@CBSADivisionTitle output,
	@CBSADivisionLevel output
	--
	-- Save results in sample table
	--
	INSERT INTO [dbo].[ADOL_STANDZ]
           ([ORIG_ID]
           ,[TOWN_CODE]
           ,[LAST_NAME]
           ,[FIRST_NAME]
           ,[MIDDLE_INIT]
           ,[SUFFX]
           ,[DOB]
           ,[SSN]
           ,[STREET1]
           ,[STREET2]
           ,[TOWN]
           ,[STATE]
           ,[ZIP1]
           ,[ZIP2]
           ,[MVL]
           ,[VOTER_STAT]
           ,[TYPE_CODE]
           ,[TYPE_ORDER]
           ,[EXP_CODE]
           ,[ADR_ADDRESS_LINE]
           ,[ADR_PRIMARY_ADDRESS]
           ,[ADR_STREET_NUMBER]
           ,[ADR_PRE_DIRECTIONAL]
           ,[ADR_PRIMARY_NAME]
           ,[ADR_STREET_TYPE]
           ,[ADR_POST_DIRECTIONAL]
           ,[ADR_SECONDARY_ADDRESS]
           ,[ADR_UNIT_DESIGNATOR]
           ,[ADR_UNIT_NUMBER]
           ,[ADR_BOX_NAME]
           ,[ADR_BOX_NUMBER]
           ,[ADR_ROUTE_NAME]
           ,[ADR_ROUTE_NUMBER]
           ,[ADR_BUILDING_NAME]
           ,[ADR_LAST_LINE]
           ,[ADR_NEIGHBORHOOD]
           ,[ADR_CITY]
           ,[ADR_STATE]
           ,[ADR_POSTAL_CDE]
           ,[ADR_POSTAL_CODE_FMT]
           ,[ADR_COUNTRY_CODE]
           ,[ADR_COUNTRY_CODE3]
           ,[ADR_COUNTRY_NAME]
           ,[ADR_ZIP5]
           ,[ADR_ZIP4]
           ,[ADR_IS_GOOD_GROUP]
           ,[ADR_IS_PARSED_FLAG]
           ,[ADR_PARSED_STATUS]
           ,[ADR_IS_GOOD_ADDRESS]
           ,[ADR_IS_FOUND_FLAG]
           ,[ADR_CITY_FOUND]
           ,[ADR_STREET_FOUND]
           ,[ADR_STREET_NUMBER_FOUND]
           ,[ADR_STREET_COMPONENT_FOUND]
           ,[ADR_POSSIBLE_CITY_ISSUES]
           ,[ADR_POSSIBLE_STREET_ISSUES]
           ,[ADR_IS_ADDRESS_VERIFIABLE]
           ,[ADR_IS_ADDRESS_CORRECTED]
           ,[ADR_POSTAL_CODE_CORRECTED]
           ,[ADR_CITY_CORRECTED]
           ,[ADR_STREET_CORRECTED]
           ,[ADR_COMP_CORRECTED]
           ,[ADR_ADDRESS_TYPE]
           ,[NME_PRENAME]
           ,[NME_PERSON]
           ,[NME_FIRST_NAME]
           ,[NME_MIDDLE_NAME]
           ,[NME_MIDDLE_NAME2]
           ,[NME_MIDDLE_NAME3]
           ,[NME_LAST_NAME]
           ,[NME_FIRST_NAME_STD]
           ,[NME_MIDDLE_STD]
           ,[NME_MIDDLE_STD2]
           ,[NME_MIDDLE_STD3]
           ,[NME_MATURITY_POSTNAME]
           ,[NME_OTHER_POSTNAME]
           ,[NME_NAME_DESSIGNATOR]
           ,[NME_GENDER]
           ,[NME_NAME_COUNT]
           ,[NME_FIRM]
           ,[NME_FIRM_COUNT]
           ,[NME_IS_GOOD_GROUP]
           ,[NME_IS_PARSED_FLAG]
           ,[NME_PARSE_STATUS]
           ,[NME_IS_GOOD_NAME]
           ,[NME_POSSIBLE_ISSUES]
           ,[SNDX_LAST_NAME]
           ,[SNDX_FIRST_NAME]
           ,[SRC_CODE]
           ,[GROUP_ID]
           ,[GROUP_ID_TMP]
           ,[ROLLED_UP_FLAG]
           ,[ROLLED_UP_TO_IDX]
           ,[RANDOM_NUMBER]
           ,[YEAR_NO]
           ,[DISTRICT_CODE]
           ,[JUROR_ID]
           ,[SWITCHES])
     VALUES (
			@ORIG_ID,
			@TOWN_CODE,
			@LAST_NAME,
			@FIRST_NAME,
			@MIDDLE_INIT,
			@SUFFX,
			@DOB,
			@SSN,
			@STREET1,
			@STREET2,
			@TOWN,
			@STATE,
			@ZIP1,
			@ZIP2,
			@MVL,
			@VOTER_STAT,
			@TYPE_CODE,
			@TYPE_ORDER,
			@EXP_CODE,

           '', -- ADR_ADDRESS_LINE, varchar(100),>
           '', -- ADR_PRIMARY_ADDRESS, varchar(100),>
           '', -- ADR_STREET_NUMBER, varchar(10),>
           '', -- ADR_PRE_DIRECTIONAL, varchar(10),>
           '', -- ADR_PRIMARY_NAME, varchar(30),>
           '', -- ADR_STREET_TYPE, varchar(10),>
           '', -- ADR_POST_DIRECTIONAL, varchar(10),>
           '', -- ADR_SECONDARY_ADDRESS, varchar(100),>
           '', -- ADR_UNIT_DESIGNATOR, varchar(10),>
           '', -- ADR_UNIT_NUMBER, varchar(10),>
           '', -- ADR_BOX_NAME, varchar(10),>
           '', -- ADR_BOX_NUMBER, varchar(10),>
           '', -- ADR_ROUTE_NAME, varchar(25),>
           '', -- ADR_ROUTE_NUMBER, varchar(10),>
           '', -- ADR_BUILDING_NAME, varchar(25),>
           '', -- ADR_LAST_LINE, varchar(100),>
           '', -- ADR_NEIGHBORHOOD, varchar(25),>
           '', -- ADR_CITY, varchar(25),>
           '', -- ADR_STATE, varchar(10),>
           '', -- ADR_POSTAL_CDE, varchar(10),>
           '', -- ADR_POSTAL_CODE_FMT, varchar(10),>
           '', -- ADR_COUNTRY_CODE, varchar(10),>
           '', -- ADR_COUNTRY_CODE3, varchar(10),>
           '', -- ADR_COUNTRY_NAME, varchar(25),>
           '', -- ADR_ZIP5, varchar(10),>
           '', -- ADR_ZIP4, varchar(10),>
           '', -- ADR_IS_GOOD_GROUP, varchar(1),>
           '', -- ADR_IS_PARSED_FLAG, varchar(1),>
           '', -- ADR_PARSED_STATUS, varchar(4),>
           '', -- ADR_IS_GOOD_ADDRESS, varchar(1),>
           '', -- ADR_IS_FOUND_FLAG, varchar(1),>
           '', -- ADR_CITY_FOUND, varchar(1),>
           '', -- ADR_STREET_FOUND, varchar(1),>
           '', -- ADR_STREET_NUMBER_FOUND, varchar(1),>
           '', -- ADR_STREET_COMPONENT_FOUND, varchar(1),>
           '', -- ADR_POSSIBLE_CITY_ISSUES, varchar(1),>
           '', -- ADR_POSSIBLE_STREET_ISSUES, varchar(1),>
           '', -- ADR_IS_ADDRESS_VERIFIABLE, varchar(1),>
           '', -- ADR_IS_ADDRESS_CORRECTED, varchar(1),>
           '', -- ADR_POSTAL_CODE_CORRECTED, varchar(1),>
           '', -- ADR_CITY_CORRECTED, varchar(1),>
           '', -- ADR_STREET_CORRECTED, varchar(1),>
           '', -- ADR_COMP_CORRECTED, varchar(1),>
           '', -- ADR_ADDRESS_TYPE, varchar(4),>
           '', -- NME_PRENAME, varchar(10),>
           '', -- NME_PERSON, varchar(50),>
           '', -- NME_FIRST_NAME, varchar(20),>
           '', -- NME_MIDDLE_NAME, varchar(20),>
           '', -- NME_MIDDLE_NAME2, varchar(20),>
           '', -- NME_MIDDLE_NAME3, varchar(20),>
           '', -- NME_LAST_NAME, varchar(25),>
           '', -- NME_FIRST_NAME_STD, varchar(20),>
           '', -- NME_MIDDLE_STD, varchar(20),>
           '', -- NME_MIDDLE_STD2, varchar(20),>
           '', -- NME_MIDDLE_STD3, varchar(20),>
           '', -- NME_MATURITY_POSTNAME, varchar(10),>
           '', -- NME_OTHER_POSTNAME, varchar(10),>
           '', -- NME_NAME_DESSIGNATOR, varchar(10),>
           '', -- NME_GENDER, varchar(1),>
           '', -- NME_NAME_COUNT, varchar(1),>
           '', -- NME_FIRM, varchar(25),>
           '', -- NME_FIRM_COUNT, varchar(1),>
           '', -- NME_IS_GOOD_GROUP, varchar(1),>
           '', -- NME_IS_PARSED_FLAG, varchar(1),>
           '', -- NME_PARSE_STATUS, varchar(4),>
           '', -- NME_IS_GOOD_NAME, varchar(1),>
           '', -- NME_POSSIBLE_ISSUES, varchar(1),>
           '', -- SNDX_LAST_NAME, varchar(4),>
           '', -- SNDX_FIRST_NAME, varchar(4),>
           '', -- SRC_CODE, varchar(10),>
           0, -- GROUP_ID, decimal(8,0),>
           0, -- GROUP_ID_TMP, decimal(8,0),>
           '', -- ROLLED_UP_FLAG, varchar(1),>
           0, -- ROLLED_UP_TO_IDX, decimal(8,0),>
           0, -- RANDOM_NUMBER, decimal(8,0),>
           @YEAR_NO,
           '', -- DISTRICT_CODE, varchar(2),>
           0, -- JUROR_ID, decimal(6,0),>
           '' -- SWITCHES, varchar(1),>)
		   )

	-- 
	-- Output from clean address for debugging
	--
	--select @Address_Name Address_Name,
	--@Company Company,  
	--@Attention Attention,
	--@Address [Address],
	--@Suite Suite ,
	--@Private_Mailbox Private_Mailbox,
	--@Address_Line_1 Address_Line_1,
	--@Address_Line_2 Address_Line_2,
	--@Address_Line_3 Address_Line_3,
	--@Address_Line_4 Address_Line_4,
	--@Address_Line_5 Address_Line_5,
	--@Address_Line_6 Address_Line_6,
	--@Address_Line_7 Address_Line_7,
	--@Address_Line_8 Address_Line_8,
	--@City City, 
	--@City_Abbreviation City_Abbreviation,
	--@ST [State],
	--@Postal_Code Postal_Code,  
	--@Postal_Code_Extended Postal_Code_Extended,
	--@Last_Line Last_Line,
	--@Country_Code Country_Code,  
	--@Country_Name Country_Name,
	--@Urbanization Urbanization,
	--@Province Province,
	--@Carrier_Route Carrier_Route,
	--@Delivery_Point_Check_Digit Delivery_Point_Check_Digit,
	--@Delivery_Point Delivery_Point,
	--@Check_Digit Check_Digit,
	--@Parsed_Address_Range Parsed_Address_Range,
	--@Parsed_Address_float Parsed_Address_float,
	--@Parsed_Pre_Direction Parsed_Pre_Direction,
	--@Parsed_Street_Name Parsed_Street_Name,
	--@Parsed_Street_Suffix Parsed_Street_Suffix,
	--@Parsed_Post_Direction Parsed_Post_Direction,
	--@Parsed_Unit_Type Parsed_Unit_Type,
	--@Parsed_Unit_float Parsed_Unit_float,
	--@Parsed_Private_Mailbox_Type Parsed_Private_Mailbox_Type,
	--@Parsed_Private_Mailbox_float Parsed_Private_Mailbox_float,
	--@Suggestion_List Suggestion_List ,
	--@County_Code County_Code,
	--@County_Name County_Name,
	--@Timezone_Code Timezone_Code,
	--@Timezone_String Timezone_String,
	--@Error_Code Error_Code,
	--@Error_String Error_String,
	--@Status_Code Status_Code,
	--@DPV_Status DPV_Status,
	--@DPV_Error_Code DPV_Error_Code,
	--@RBDI_Code RBDI_Code,
	--@CMRA CMRA,
	--@Address_Type_Code Address_Type_Code,
	--@Address_Type_String Address_Type_String,
	--@MSA MSA,
	--@PMSA PMSA,
	--@Congressional_District Congressional_District,
	--@LACS_Code LACS_Code,
	--@Automation_Code Automation_Code,
	--@Facility_Code Facility_Code,
	--@Zip_Type_Code Zip_Type_Code,
	--@Latitude Latitude,
	--@Longitude Longitude,
	--@Census_Tract Census_Tract,
	--@Census_Block Census_Block,
	--@FirstName First_Name,  
	--@Middle_Name Middle_Name,  
	--@LastName Last_Name,  
	--@Name_Prefix Name_Prefix,  
	--@Name_Suffix Name_Suffix ,  
	--@Standardized_First_Name Standardized_First_Name,
	--@Gender Gender,
	--@First_Name_2 First_Name_2,
	--@Middle_Name_2 Middle_Name_2,
	--@Last_Name_2 Last_Name_2,
	--@Name_Prefix_2 Name_Prefix_2,
	--@Name_Suffix_2 Name_Suffix_2,
	--@Standardized_First_Name_2 Standardized_First_Name_2,
	--@Gender_2 Gender_2,
	--@Name_Parse_Status_Code Name_Parse_Status_Code, 
	--@Phone_float Phone_float,  
	--@Phone_float_Output_Format Phone_float_Output_Format,
	--@New_Phone_float New_Phone_float,
	--@New_Phone_Area_Code New_Phone_Area_Code,
	--@Phone_Area_Code Phone_Area_Code,  
	--@Phone_Prefix Phone_Prefix,  
	--@Phone_Suffix Phone_Suffix,  
	--@Phone_Extension Phone_Extension,
	--@Phone_Distance Phone_Distance,
	--@Phone_Check_Status_Code Phone_Check_Status_Code,
	--@Phone_Check_Error_Code Phone_Check_Error_Code,
	--@AddressKey AddressKey ,
	--@CountyFIPS CountyFIPS ,
	--@CountyName CountyName ,
	----ref SqlString standardizedFirstNameField, -> Standardized_First_Name (already exists)
	--@Standardized_Middle_Name Standardized_Middle_Name ,
	--@Results Results ,
	--@GenericAddressLineFormat GenericAddressLineFormat ,
	--@CBSACode CBSACode ,
	--@CBSATitle CBSATitle ,
	--@CBSALevel CBSALevel ,
	--@CBSADivisionCode CBSADivisionCode ,
	--@CBSADivisionTitle CBSADivisionTitle ,
	--@CBSADivisionLevel CBSADivisionLevel 

	Fetch next from cur
	into @ORIG_ID,@TOWN_CODE,@LAST_NAME,@FIRST_NAME,@MIDDLE_INIT,@SUFFX,@DOB,@SSN,
	@STREET1,@STREET2,@TOWN,@STATE,@ZIP1,@ZIP2,@MVL,@VOTER_STAT,@TYPE_CODE,@TYPE_ORDER,@EXP_CODE,@YEAR_NO

  end -- loop

select * from ADOL_ORIG
select * from ADOL_STANDZ

close cur
deallocate cur